﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VIRP_WEB.BaseCode;
using VIRP_WEB.SoaServices;

namespace VIRP_WEB.Common
{
    public partial class PatientCprsMain : BasePage
    {
        #region Variable Declarations

        //private string inSiteCode;
        //private string inDUZ;
        //private string inDFN;

        //private string inServerIP;
        //private string inServerPort;

        //private int inTBIEvaluationNoteId;
        //private int inTBIFollowUpNoteId;

        protected NotesManager notesManager;

        #endregion

        #region Protected Methods

        protected override void Page_Load(object sender, EventArgs e)
        {
            notesManager = new NotesManager();

            if (!IsPostBack)
            {
                base.Page_Load(sender, e);

                //Get parameters from session variables 
                //inSiteCode = Helpers.GetStringFromSessionVariable(Session["SiteCode"]);
                //inDUZ = Helpers.GetStringFromSessionVariable(Session["DUZ"]);
                //inDFN = Helpers.GetStringFromSessionVariable(Session["DFN"]);
                //inServerIP = Helpers.GetStringFromSessionVariable(Session["ServerIP"]);
                //inServerPort = Helpers.GetStringFromSessionVariable(Session["ServerPort"]);

                //int.TryParse(Helpers.GetStringFromSessionVariable(Session["TBIEvaluationNoteId"]), out inTBIEvaluationNoteId);
                //int.TryParse(Helpers.GetStringFromSessionVariable(Session["TBIFollowUpNoteId"]), out inTBIFollowUpNoteId);

                //if (string.IsNullOrEmpty(inDUZ)
                //    || string.IsNullOrEmpty(inDFN)
                //    || string.IsNullOrEmpty(inSiteCode)
                //    || string.IsNullOrEmpty(inServerIP)
                //    || string.IsNullOrEmpty(inServerPort))
                if (ViaSession == null 
                    || string.IsNullOrEmpty(ViaSession.DUZ)
                    || string.IsNullOrEmpty(ViaSession.DFN)
                    || string.IsNullOrEmpty(ViaSession.SiteCode)
                    || string.IsNullOrEmpty(ViaSession.ServerIP)
                    || string.IsNullOrEmpty(ViaSession.ServerPort))
                    {
                    //if any value is not passed in then the page was called incorrectly, display error message to user
                    lblMessage.Text = "Incorrect value has been passed from CPRS.";
                }

                //ViaServiceData viaData = new ViaServiceData();
                //viaData.DUZ = inDUZ;
                //viaData.DFN = inDFN;
                //viaData.SiteCode = inSiteCode;
                //viaData.ServerIP = inServerIP;
                //viaData.ServerPort = inServerPort;
                //viaData.CprsSentTBIEvaluationNoteId = inTBIEvaluationNoteId;
                //viaData.CprsSentTBIFollowUpNoteId = inTBIFollowUpNoteId;

                ////notesManager.AddToSessionViaData(viaData);
                //notesManager.ViaData = viaData;
                notesManager.ViaData = ViaSession;
                notesManager.PatientCprsLoad();
            }
            else
            {
                //ViaServiceData viaData;

                try
                {
                    //viaData = (ViaServiceData)Session["ViaData"];
                    notesManager.ViaData = ViaSession;
                }
                catch (Exception ex2)
                {
                    ServiceInterfaceManager.LogError(ex2.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                }
            }

            //Get Patient and redirect to referral detail page of specific registry; target registry is already set in base page_load
            REFERRAL r = ServiceInterfaceManager.REFERRAL_GET_BY_PATIENTICN(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, notesManager.ViaData.PatientICN);
            if (r != null)
            {
                UserSession.CurrentRegistryId = r.STD_REGISTRY_ID;
                UserSession.CurrentReferralId = r.REFERRAL_ID;
                UserSession.CurrentPatientId = r.PATIENT_ID;

                if (r.PROVIDER_ID != null)
                    UserSession.CurrentProviderId = r.PROVIDER_ID.Value;

                UserSession.FilterBySelectedPatient = true;

                Response.Redirect("~/Common/Referral.aspx", false);
            }
            else
            {
                pnlPatientNotFound.Visible = true;
            }
        }

        #endregion
    }
}